#!/bin/bash

# This script is ask user to add the EcviewPro server information

echo -n "##########################################################"
echo
echo -n "#Please enter the following data to config the EcviewPro.#"
echo 
echo -n "##########################################################"
echo
###########################################
function initSAnmDB(){
    if [ -e $whole_nms_server_dir/conf/anm.db.properties ]; then
        rm $whole_nms_server_dir/conf/anm.db.properties
    fi
    echo "hibernate.default_schema=networkManager
hibernate.dialect=org.hibernate.dialect.PostgreSQLDialect
hibernate.connection.url.1=jdbc\:postgresql\://127.0.0.1\:5557/ecview
hibernate.connection.driver_class=org.postgresql.Driver
current.link=1
" > $whole_nms_server_dir/conf/anm.db.properties

echo "generate $whole_nms_server_dir/conf/anm.db.properties"
} 
###########################################
function initRAnmDB(){
    if [ -e $whole_nms_server_dir/conf/anm.db.properties ]; then
        rm $whole_nms_server_dir/conf/anm.db.properties
    fi
    echo "hibernate.default_schema=networkManager
hibernate.dialect=org.hibernate.dialect.PostgreSQLDialect
hibernate.connection.url.1=jdbc\:postgresql\://$db_ip\:5558/ecview
hibernate.connection.driver_class=org.postgresql.Driver
current.link=1
" > $whole_nms_server_dir/conf/anm.db.properties

echo "generate $whole_nms_server_dir/conf/anm.db.properties"
}
###########################################
function initSArenaDB(){
    if [ -e $whole_nms_server_dir/conf/arena.db.properties ]; then    
        rm $whole_nms_server_dir/conf/arena.db.properties
    fi
    echo "hibernate.default_schema=arena
hibernate.dialect=org.hibernate.dialect.PostgreSQLDialect
hibernate.connection.url.1=jdbc\:postgresql\://127.0.0.1\:5557/ecview
hibernate.connection.driver_class=org.postgresql.Driver
current.link=1
" > $whole_nms_server_dir/conf/arena.db.properties

echo "generate $whole_nms_server_dir/conf/arena.db.properties"
}
###########################################
function initRArenaDB(){
    if [ -e $whole_nms_server_dir/conf/arena.db.properties ]; then    
        rm $whole_nms_server_dir/conf/arena.db.properties
    fi
    echo "hibernate.default_schema=arena
hibernate.dialect=org.hibernate.dialect.PostgreSQLDialect
hibernate.connection.url.1=jdbc\:postgresql\://$db_ip\:5558/ecview
hibernate.connection.driver_class=org.postgresql.Driver
current.link=1
" > $whole_nms_server_dir/conf/arena.db.properties

echo "generate $whole_nms_server_dir/conf/arena.db.properties"
}
###########################################
function initSServerFile(){
    if [ -e $whole_nms_server_dir/conf/server.properties ]; then
        rm $whole_nms_server_dir/conf/server.properties
    fi
    echo "arena.server.port = 5555
arena.server.jndi.port = 5556
arena.server.http.port = 8080
arena.server.update.port = 8880
arena.server.tftp.port = 69
arena.server.trapreciever.port = 162
arena.server.syslog.port = 1514
arena.server.ipaddress = 
arena.server.withoutDB = true
arena.server.cluster = false
arena.server.redundant = false" > $whole_nms_server_dir/conf/server.properties   
echo "generate $whole_nms_server_dir/conf/server.properties"
}
###########################################
function initRServerFile(){
    if [ -e $whole_nms_server_dir/conf/server.properties ]; then
        rm $whole_nms_server_dir/conf/server.properties
    fi
	echo "arena.server.port = 5555
arena.server.jndi.port = 5556
arena.server.http.port = 8080
arena.server.update.port = 8880
arena.server.tftp.port = 69
arena.server.trapreciever.port = 162
arena.server.syslog.port = 1514
arena.server.ipaddress = 
arena.server.withoutDB = true
arena.server.cluster = false
arena.server.redundant = true" > $whole_nms_server_dir/conf/server.properties
echo "generate $whole_nms_server_dir/conf/server.properties"
}
###########################################
function addUpstartFile(){
    if [ ! -e /etc/init.d/ecview_pro ]; then    
        echo "#! /bin/sh
### BEGIN INIT INFO
# Provides:          Edge-core
# Required-Start:    \$remote_fs \$syslog
# Required-Stop:     \$remote_fs \$syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start ECView Pro
# Description:       Execute ECView Pro server.
### END INIT INFO

PATH=/sbin:/usr/sbin:/bin:/usr/bin
NAME=ECViewProServer
DESC=\"Description of the service\"
DAEMON=$whole_nms_server_dir/\$NAME
PID_FILE=$whole_nms_server_dir/\$NAME.pid
VM_WEB=/home/user/webDataNMS/build/debug-x86_64-linux/etc

# Exit if the package is not installed
[ -x \"\$DAEMON\" ] || exit 0

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.2-14) to ensure that this file is present
# and status_of_proc is working.
. /lib/lsb/init-functions

#
# Function that starts the daemon/service
#
do_start()
{
	echo \"\$NAME starting ...\"
	if [ ! -f \$PID_FILE ]; then
	    cd $whole_nms_server_dir
	    sudo ./ECViewProServer 2>> /dev/null >> /dev/null & echo \$! > \$PID_FILE
	    
	    #avoid not log java pid number
	    sleep 10
	    
	    pgrep java >> \$PID_FILE
	    
	    #run VM WEB
	    cd \$VM_WEB
	    ./webstart.sh start
        
        pgrep mongoose >> \$PID_FILE
	    
	    echo \"\$NAME started ...\"
	else
		# read pid content
		read line < \$PID_FILE
		
		if ! kill $line > /dev/null 2>&1; then
			sudo rm -rf \$PID_FILE
			
			sudo ./ECViewProServer 2>> /dev/null >> /dev/null & echo \$! > \$PID_FILE
	    
	        #avoid not log java pid number
	        sleep 10
	        
	        pgrep java >> \$PID_FILE
	        
	        #run VM WEB
		    cd \$VM_WEB
		    ./webstart.sh start
	        
	        pgrep mongoose >> \$PID_FILE
	        echo \"\$NAME started ...\"
		else
			echo \"\$NAME is already running ...\"
		fi
	fi
}

#
# Function that stops the daemon/service
#
do_stop()
{
	if [ -f \$PID_FILE ]; then            
	    echo \"\$NAME stoping ...\"
	    while read line; do  sudo kill \$line; done < \$PID_FILE
	    echo \"\$NAME stopped ...\"
	    sudo rm -rf \$PID_FILE            
	else
	    echo \"\$NAME is not running ...\"
	fi
}

case \"\$1\" in
  start)
        do_start
        ;;
  stop)
        do_stop
        ;;
  status)
        status_of_proc \"\$DAEMON\" \"\$NAME\" && exit 0 || exit \$?
        ;;  
  restart|force-reload)
        #
        # If the "reload" option is implemented then remove the
        # 'force-reload' alias
        #
        echo \"Restarting \$DESC\" \"\$NAME\"
        do_stop
        do_start
        ;;
  *)
        #echo \"Usage: $SCRIPTNAME {start|stop|restart|reload}\" >&2
        echo \"Usage: \$SCRIPTNAME {start|stop|status|restart}\" >&2
        exit 3
        ;;
esac

" | sudo tee /etc/init.d/ecview_pro
    sudo chmod 755 /etc/init.d/ecview_pro
    sudo update-rc.d ecview_pro defaults
    sudo update-rc.d ecview_pro enable
    echo "generate /etc/init.d/ecview_pro"
else
    echo ecview_pro already exist!
fi
}
###########################################
function addUninstallFile(){   
echo "#!/bin/bash

# This script is remove EcviewPro service
NAME=ECViewProServer
PID_FILE=$whole_nms_server_dir/\$NAME.pid

if [ -f \$PID_FILE ]; then            
    echo \"\$NAME stoping ...\"
    while read line; do  sudo kill \$line; done < \$PID_FILE
    echo \"\$NAME stopped ...\"
    sudo rm -rf \$PID_FILE
fi

sudo update-rc.d -f ecview_pro remove
sudo rm -rf /etc/init.d/ecview_pro
sudo rm -rf /etc/iptables.rules
sudo rm -rf /etc/network/if-post-down.d/iptables
sudo rm -rf /etc/network/if-pre-up.d/iptables
sudo rm -rf $whole_nms_server_dir
sudo rm -rf /home/user/webDataNMS
sudo rm -rf /home/user/webDataNMS.tar.gz" > $whole_nms_server_dir/uninstall.sh
sudo chmod +x $whole_nms_server_dir/uninstall.sh
echo "generate $whole_nms_server_dir/uninstall.sh"
}
###########################################
function natSyslogPort(){ 
NAT_FILE=/etc/iptables.rules
if [ ! -e \$NAT_FILE ]; then 
    sudo iptables -A PREROUTING -t nat -p udp --dport 514 -j REDIRECT --to-port 1514
    sudo sh -c 'sudo iptables-save > /etc/iptables.rules'    
    echo "#!/bin/sh
iptables-restore < /etc/iptables.rules
exit 0" | sudo tee /etc/network/if-pre-up.d/iptables
    echo "#!/bin/sh
iptables-save -c > /etc/iptables.rules
if [ -f /etc/iptables.rules ]; then
iptables-restore < /etc/iptables.rules
fi
exit 0" | sudo tee /etc/network/if-post-down.d/iptables
    
    sudo chmod +x /etc/network/if-post-down.d/iptables
    sudo chmod +x /etc/network/if-pre-up.d/iptables
fi
}
###########################################
function addVMWeb(){ 
VM_WEB=/home/user
if [ ! -d "$VM_WEB" ]; then
	sudo mkdir $VM_WEB
fi
sudo cp $whole_nms_server_dir/webDataNMS.tar.gz $VM_WEB/webDataNMS.tar.gz
cd /home/user
sudo tar -zxvf webDataNMS.tar.gz
}
###########################################
function debug_file(){ 
echo "#!/bin/bash

# This script is debug for EcviewPro service
echo \"total file:\"
lsof -n|grep \$1|wc -l
" > $whole_nms_server_dir/debug.sh
sudo chmod +x $whole_nms_server_dir/debug.sh
echo "generate $whole_nms_server_dir/debug.sh"
}
###########################################

# Ask the root directory of ECViewPro and check it is correct

echo -n "Enter the absolute root directory of ECViewPro Server [ENTER]: "
read root_directory
# Check the server and plarform directory is exist or not

server_dir='/ECViewProServer'
whole_nms_server_dir=$root_directory$server_dir
if [ ! -d "$whole_nms_server_dir" ]; then
echo -n "ECViewPro directory do not exist, please enter ECViewPro root directory again"
exit 1
fi

echo -n "Enter the mode of ECViewPro Server (standalone/redundant): "
read mode

if [ "$mode" = "standalone" ]; then
	initSAnmDB;
	initSArenaDB;
	initSServerFile;
	addUpstartFile;
	addUninstallFile;
    natSyslogPort;
    addVMWeb;
    debug_file;
elif [ "$mode" = "redundant" ]; then
	# Ask the db server ip address
	
	echo -n "Enter the ECViewPro delegate database server IP address [ENTER]: "
	read db_ip

	initRAnmDB;
	initRArenaDB;
	initRServerFile;
	addUpstartFile;
	addUninstallFile;
    natSyslogPort;
    addVMWeb;
    debug_file;
else
  echo -n "ECViewPro Server wrong mode"
  exit 1
fi