#!/bin/bash

# This script will recover DB data

if [ "$EUID" -ne 0 ]
    then echo "Please run as root"
    exit
fi

read -p "Enter the database server port [ENTER]: " __PORT__

echo -n "######################"
echo
echo -n "#Recover DB data.    #"
echo
echo -n "######################"
echo

file="ecviewPro.backup.sql"
if [ ! -f "$file" ]
    then echo "File '${file}' not found."       
else
    pg_ctlcluster 9.4 ecview stop -m fast
    pg_ctlcluster 9.4 ecview start
    dropdb -U arenaDbUser ecview -p $__PORT__
    createdb -U arenaDbUser ecview -p $__PORT__
    psql -f ecviewPro.backup.sql ecview arenaDbUser -p $__PORT__
fi
