CREATE TABLE networkmanager.NT_device_resource(
	id serial8
  , nf_device bigint NOT NULL
  , nf_cpu SMALLINT
  , nf_memory SMALLINT
  , nf_record_time TIMESTAMP with time zone NOT null
  , PRIMARY KEY(id)
);

CREATE TABLE networkmanager.NT_device_rmon(
	id serial8
  , nf_device bigint NOT NULL
  , nf_port SMALLINT
  , nf_drop double precision
  , nf_packets double precision
  , nf_broadcast_packets double precision
  , nf_multicast_packets double precision
  , nf_crc_align_errors double precision
  , nf_undersize_packets double precision
  , nf_oversize_packets double precision
  , nf_fragments double precision
  , nf_jabbers double precision
  , nf_collisions double precision
  , nf_64_octets double precision
  , nf_65_127_octets double precision
  , nf_128_255_octets double precision
  , nf_256_511_octets double precision
  , nf_512_1023_octets double precision
  , nf_1024_1518_octets double precision
  , nf_hc_packets double precision
  , nf_bandwidth_util double precision
  , nf_of_packet_rate double precision
  , nf_of_byte_rate double precision
  , nf_record_time TIMESTAMP with time zone NOT null
  , PRIMARY KEY(id)
);

ALTER TABLE networkManager.NT_device_resource
  ADD CONSTRAINT FK_NT_device_resource
  	  FOREIGN KEY (nf_device)
  	  REFERENCES networkManager.NT_Device (id)
   ON DELETE CASCADE;
   
ALTER TABLE networkManager.NT_device_rmon
  ADD CONSTRAINT FK_NT_device_rmon
  	  FOREIGN KEY (nf_device)
  	  REFERENCES networkManager.NT_Device (id)
   ON DELETE CASCADE;