#!/bin/bash

# This script will update db schema

read -p "Enter the database server ip [ENTER]: " __HOST__
read -p "Enter the database server port [ENTER]: " __PORT__

echo -n "######################"
echo
echo -n "#Update arena schema.#"
echo 
echo -n "######################"
echo

psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE Arena.AT_Users ADD af_session_timeout INTEGER;'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE Arena.AT_Users ADD af_ac_username VARCHAR(32);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE Arena.AT_Users ADD af_ac_password VARCHAR(100);'

echo -n "######################"
echo
echo -n "#Update arena data.#"
echo 
echo -n "######################"
echo

psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "UPDATE Arena.AT_Users SET af_session_timeout=600, af_ac_username='admin', af_ac_password='' WHERE id=1;"
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "UPDATE Arena.AT_Users SET af_session_timeout=600, af_ac_username='admin', af_ac_password='' WHERE id=2;"
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "UPDATE Arena.AT_Users SET af_session_timeout=600, af_ac_username='admin', af_ac_password='' WHERE id=3;"
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "UPDATE Arena.AT_Users SET af_session_timeout=600, af_ac_username='admin', af_ac_password='' WHERE id=4;"
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "UPDATE Arena.AT_Users SET af_session_timeout=600, af_ac_username='admin', af_ac_password='' WHERE id=5;"

echo -n "######################"
echo
echo -n "#Update network schema.#"
echo 
echo -n "######################"
echo

psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_hardware_version VARCHAR(20);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_microcode_version VARCHAR(20);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_loader_version VARCHAR(20);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_bootroom_version VARCHAR(20);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_port_number VARCHAR(10);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_power_status VARCHAR(30);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_role_in_system VARCHAR(20);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_service_tag VARCHAR(80);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_model_number VARCHAR(15);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_epld_version VARCHAR(20);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'CREATE TABLE networkManager.NT_Stacking_Settings (id serial8, nf_device_id int8, nf_index SMALLINT, nf_sw_version VARCHAR(20), nf_serial_number VARCHAR(80), nf_hardware_version VARCHAR(20), nf_microcode_version VARCHAR(20), nf_loader_version VARCHAR(20), nf_bootroom_version VARCHAR(20), nf_port_number VARCHAR(10), nf_power_status VARCHAR(30), nf_role_in_system VARCHAR(20), nf_service_tag VARCHAR(80), nf_model_number VARCHAR(15), nf_epld_version VARCHAR(20), PRIMARY KEY (id));'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.nt_schedule_task ADD nf_byDevice boolean;'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.nt_schedule_task ADD nf_total INTEGER;'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.nt_schedule_task ADD nf_success INTEGER;'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.nt_schedule_task ADD nf_fail INTEGER;'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'CREATE TABLE networkManager.nt_schedule_upload_task (id serial8, nf_file bigint, nf_AP_image boolean, nf_running_config boolean, nf_upload_method INTEGER, nf_reboot boolean, nf_next boolean, nf_user bigint, nf_overwrite boolean, nf_replace boolean, PRIMARY KEY (id)   , CONSTRAINT FK_schedule_upload FOREIGN KEY (id) REFERENCES networkManager.nt_schedule_task (id));'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'CREATE TABLE networkmanager.nt_schedule_group (nf_schedule INTEGER NOT NULL, nf_group INTEGER NOT NULL, PRIMARY KEY(nf_schedule, nf_group));'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Stacking_Settings ADD CONSTRAINT FK_Stacking_Settings_1 FOREIGN KEY (nf_device_id) REFERENCES networkManager.NT_Device (id) ON DELETE CASCADE;'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.nt_schedule_group ADD CONSTRAINT FK_NT_SCHEDULE_GROUP_1 FOREIGN KEY (nf_schedule) REFERENCES networkManager.nt_schedule_task (id) ON DELETE CASCADE ON UPDATE CASCADE;'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.nt_schedule_group ADD CONSTRAINT FK_NT_SCHEDULE_GROUP_2 FOREIGN KEY (nf_group) REFERENCES networkManager.NT_CM_Category (id) ON DELETE CASCADE;'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.nt_schedule_upload_task ADD CONSTRAINT FK_NT_schedule_upload_1 FOREIGN KEY (nf_file) REFERENCES networkManager.NT_CM_File (id) ON DELETE CASCADE ON UPDATE NO ACTION;'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.NT_Device ADD nf_ap_version VARCHAR(100);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.nt_schedule_task ALTER COLUMN nf_name TYPE VARCHAR(32);'
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c 'ALTER TABLE networkManager.nt_schedule_task ADD nf_force boolean;'

echo -n "######################"
echo
echo -n "#Update network data.#"
echo 
echo -n "######################"
echo

psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "INSERT INTO networkManager.NT_networkmanager_Preference_Keys VALUES(192, 'ae.sphere.arena.networkManager.platform.activeMonitor.preferences.user',1, 'string', 'admin');"
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "INSERT INTO networkManager.NT_networkmanager_Preference_Keys VALUES(193, 'ae.sphere.arena.networkManager.platform.activeMonitor.preferences.pwd',1, 'string', '');;"
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "INSERT INTO networkManager.NT_networkmanager_Preference_Keys VALUES(194, 'ae.sphere.arena.networkManager.platform.http.preference.port',1, 'int', '443');;"
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "INSERT INTO networkManager.NT_networkmanager_Preference_Keys VALUES(200, 'ae.sphere.arena.networkManager.platform.http.preference.type',1, 'string', 'default');;"
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "INSERT INTO networkManager.NT_networkmanager_Preference_Keys VALUES(714, 'ae.sphere.arena.networkManager.dst',1, 'int', '0');"
psql -h $__HOST__ -p $__PORT__ -U arenaDbUser ecview -c "UPDATE networkManager.NT_networkmanager_Preference_Keys SET nf_preference_Default='error,failed,invalid,ambiguous,bad,incomplete,incorrect,not,denied,cannnot,unable,failure,out,can''t,does''t' WHERE id=176;"