ALTER TABLE networkManager.nt_ac_backup_acl_rule
  ADD CONSTRAINT FK_NT_BACKUP_ACL
  	  FOREIGN KEY (nf_acl)
  	  REFERENCES networkManager.nt_ac_backup_acl (id)
   ON DELETE CASCADE;
   
ALTER TABLE networkManager.nt_ac_backup_ratelimit_rule
  ADD CONSTRAINT FK_NT_BACKUP_RATELIMIT
  	  FOREIGN KEY (nf_ratelimit)
  	  REFERENCES networkManager.nt_ac_backup_ratelimit (id)
   ON DELETE CASCADE;
   
ALTER TABLE networkManager.nt_ac_backup_wifi_schedule_rule
  ADD CONSTRAINT FK_NT_BACKUP_SCHEDULE
  	  FOREIGN KEY (nf_schedule)
  	  REFERENCES networkManager.nt_ac_backup_wifi_schedule (id)
   ON DELETE CASCADE;
   
ALTER TABLE networkManager.nt_ac_backup_acl
  ADD CONSTRAINT FK_NT_BACKUP_ACL_DEVICE
  	  FOREIGN KEY (nf_ac)
  	  REFERENCES networkManager.NT_Device (id)
   ON DELETE CASCADE;
   
ALTER TABLE networkManager.nt_ac_backup_ratelimit
  ADD CONSTRAINT FK_NT_BACKUP_RATELIMIT_DEVICE
  	  FOREIGN KEY (nf_ac)
  	  REFERENCES networkManager.NT_Device (id)
   ON DELETE CASCADE;
   
ALTER TABLE networkManager.nt_ac_backup_wifi_schedule
  ADD CONSTRAINT FK_NT_BACKUP_SCHEDULE_DEVICE
  	  FOREIGN KEY (nf_ac)
  	  REFERENCES networkManager.NT_Device (id)
   ON DELETE CASCADE;

CREATE TABLE networkManager.nt_template (
       id serial8
     , nf_name varchar(32)
     , PRIMARY KEY (id)
);

CREATE TABLE networkManager.nt_template_map (
       nf_template INTEGER NOT NULL
 	 , nf_fragment INTEGER NOT NULL
 	 , PRIMARY KEY(nf_template, nf_fragment)
);

CREATE TABLE networkManager.nt_fragment (
       id serial8
     , nf_name varchar(32)
     , nf_action varchar(128)
     , PRIMARY KEY (id)
);

CREATE TABLE networkManager.nt_fragment_action (
       id serial8
     , nf_name varchar(128)
     , nf_type varchar(32)
     , nf_value varchar(128)
     , nf_fragment serial8
     , PRIMARY KEY (id)
     , CONSTRAINT "fragment_action_FK" FOREIGN KEY (nf_fragment)
      REFERENCES networkmanager.nt_fragment (id) MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE CASCADE
);

ALTER TABLE networkManager.nt_template_map
  ADD CONSTRAINT FK_NT_template_map_1
  	  FOREIGN KEY (nf_template)
  	  REFERENCES networkManager.nt_template (id)
   ON DELETE CASCADE
   ON UPDATE CASCADE;

ALTER TABLE networkManager.nt_template_map
  ADD CONSTRAINT FK_NT_nt_template_map_2
  	  FOREIGN KEY (nf_fragment)
  	  REFERENCES networkManager.nt_fragment (id)
   ON DELETE CASCADE;
